/*
 * AtomObserverUnitTest.hpp
 *
 *  Created on: Dec 19, 2011
 *      Author: heber
 */

#ifndef ATOMOBSERVERUNITTEST_HPP_
#define ATOMOBSERVERUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <cppunit/extensions/HelperMacros.h>

#include "types.hpp"

class UpdateCountObserver;
class NotificationObserver;

// we prefer enum over define
enum { ATOM_COUNT = 2 };

class atom;

class AtomObserverTest : public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE( AtomObserverTest );
  CPPUNIT_TEST ( AtomAddTest );
  CPPUNIT_TEST ( AtomElementTest );
  CPPUNIT_TEST ( AtomMoveTest );
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp();
  void tearDown();

  void AtomAddTest();
  void AtomElementTest();
  void AtomMoveTest();

private:
  atom *atoms [ATOM_COUNT];
  atomId_t atomIds [ATOM_COUNT];

  UpdateCountObserver *observer;
  NotificationObserver *observer1;
  NotificationObserver *observer2;
};

#endif /* ATOMOBSERVERUNITTEST_HPP_ */
