/*
 * AtomObserver.hpp
 *
 *  Created on: Nov 30, 2011
 *      Author: heber
 */

#ifndef ATOMOBSERVER_HPP_
#define ATOMOBSERVER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/Observer/Relay.hpp"
#include "CodePatterns/Singleton.hpp"

class atom;
class World;

/** The AtomObserver is a central instance to all changes occuring within atoms.
 *
 * The intent is that if a class wants to know about changes in just _any_ atom,
 * he may register singly to this class and not to each and every atom. This also
 * keeps him updated in case of removed or added atoms.
 *
 */
class AtomObserver : public Singleton<AtomObserver>, public Relay
{
  //!> grant Singleton access to cstor and dstor.
  friend class Singleton<AtomObserver>;

  //!> grant World access to AtomInserted.
  friend class World;
public:

private:
  void AtomInserted(atom *res);

  // private constructor and destructor due to singleton
  AtomObserver();
  ~AtomObserver();
};


#endif /* ATOMOBSERVER_HPP_ */
