/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AtomObserver.cpp
 *
 *  Created on: Nov 30, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "AtomObserver.hpp"

#include "CodePatterns/Singleton_impl.hpp"

#include "Atom/atom.hpp"
#include "Atom/atom_observable.hpp"


/** Private constructor of class AtomObserver.
 *
 */
AtomObserver::AtomObserver() :
  Relay(std::string("AtomObserver"))
{
  Channels *OurChannel = new Channels();
  NotificationChannels.insert( std::make_pair(this, OurChannel) );
  OurChannel->addChannel(AtomObservable::PositionChanged);
  OurChannel->addChannel(AtomObservable::ElementChanged);
}

/** Private Destructor of class AtomObserver.
 *
 */
AtomObserver::~AtomObserver()
{}

/** Function to call when a new atom has been created.
 *
 * @param res
 */
void AtomObserver::AtomInserted(atom *res)
{
  res->signOn(this, AtomObservable::PositionChanged);
  res->signOn(this, AtomObservable::ElementChanged);
}

CONSTRUCT_SINGLETON(AtomObserver)
