/*
 * GLMoleculeObject_bond.hpp
 *
 *  Created on: Aug 17, 2011
 *      Author: heber
 */

#ifndef GLMOLECULEOBJECT_BOND_HPP_
#define GLMOLECULEOBJECT_BOND_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "GLMoleculeObject.hpp"

#include <vector>
#include <boost/any.hpp>
#include <boost/function.hpp>

#include "LinearAlgebra/Vector.hpp"

#include "types.hpp"

#include "UIElements/Qt4/InstanceBoard/QtObservedBond.hpp"

class atom;

class GLWorldScene;

class GLMoleculeObject_bond : public GLMoleculeObject
{
  Q_OBJECT
public:
  enum SideOfBond { left, right };

  typedef std::pair<atomId_t, atomId_t> bondIds_t;

  GLMoleculeObject_bond(
      QGLSceneNode *mesh[],
      QObject *parent,
      QtObservedBond::ptr &_ObservedBond,
      const enum SideOfBond side);
  virtual ~GLMoleculeObject_bond();

signals:
  void BondRemoved(const atomId_t leftnr, const atomId_t rightnr);

private slots:
  //!> grant GLMoleculeObject_molecule acess to reset functions
  friend class GLMoleculeObject_molecule;

  /** Recalculates the element of the cylinder representing the bond.
   *
   */
  void resetElement();

  /** Recalculates the position of the cylinder representing the bond.
   *
   */
  void resetPosition();

  /** Recalculates the width of the cylinder representing the bond's degree.
   *
   */
  void resetWidth();

private:
  //!> which part of half the bond this object represents
  const enum SideOfBond BondSide;
  //!> state of the bond this object visually represents
  const QtObservedBond::ptr ObservedBond;
};



#endif /* GLMOLECULEOBJECT_BOND_HPP_ */
