/*
 * GLMoleculeObject_atom.hpp
 *
 *  Created on: Aug 17, 2011
 *      Author: heber
 */

#ifndef GLMOLECULEOBJECT_ATOM_HPP_
#define GLMOLECULEOBJECT_ATOM_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "GLMoleculeObject.hpp"

#include <vector>
#include <boost/any.hpp>

#include "CodePatterns/ObservedValue.hpp"

#include "UIElements/Views/Qt4/Qt3D/GLMoleculeObject_bond.hpp"
#include "UIElements/Qt4/InstanceBoard/QtObservedAtom.hpp"
#include "types.hpp"

class GLWorldScene;
class QtObservedInstanceBoard;

class GLMoleculeObject_atom : public GLMoleculeObject
{
  Q_OBJECT
public:
  GLMoleculeObject_atom(
      QGLSceneNode *mesh[],
      QObject *parent,
      QtObservedAtom::ptr &_ObservedAtom
      );
  virtual ~GLMoleculeObject_atom();

  void draw(QGLPainter *painter, const QVector4D &cameraPlane);

private slots:
  void wasClicked();
  void resetIndex(const atomId_t, const atomId_t);
  void resetElement();
  void resetPosition();
  void resetSelected();

signals:
  void clicked(atomId_t);
  void BondsAdded(const atomId_t _left, const atomId_t _right, const GLMoleculeObject_bond::SideOfBond side);
  void BondsRemoved(const atomId_t _left, const atomId_t _right);
  void indexChanged(GLMoleculeObject_atom*, const atomId_t _oldid, const atomId_t _newid);

private:
  void init(const atomId_t _id);

private:
  //!> current list of bonds to compare new onw against for changes
  QtObservedAtom::ListOfBonds_t ListOfBonds;

  QtObservedAtom::ptr ObservedAtom;
};



#endif /* GLMOLECULEOBJECT_ATOM_HPP_ */
