/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * \file JobAdder.cpp
 *
 * This file strongly follows the Serialization example from the boost::asio
 * library (see client.cpp)
 *
 *  Created on: Nov 27, 2011
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// boost asio needs specific operator new
#include <boost/asio.hpp>

#include "CodePatterns/MemDebug.hpp"

#include <iostream>
#include <vector>
#include <boost/lexical_cast.hpp>

#include "atexit.hpp"
#include "CodePatterns/Info.hpp"
#include "CodePatterns/Log.hpp"
#include "Controller/FragmentController.hpp"
#include "FragmentJob.hpp"
#include "FragmentResult.hpp"


int main(int argc, char* argv[])
{
  // from this moment on, we need to be sure to deeinitialize in the correct order
  // this is handled by the cleanup function
  atexit(cleanUp);

  setVerbosity(3);

  size_t Exitflag = 0;
  try
  {
    // Check command line arguments.
    if (argc != 4)
    {
      std::cerr << "Usage: " << argv[0] << " <host> <port> <number of jobs>" << std::endl;
      return 1;
    }
    const int NoJobs = boost::lexical_cast<int>(argv[3]);
    boost::asio::io_service io_service;
    FragmentController controller(io_service);

    LOG(1, "INFO: Creating " << NoJobs << " jobs for the server.");
    std::vector<FragmentJob> jobs;
    for (JobId_t i = 1; i <= NoJobs; ++i) {
      FragmentJob testJob(std::string("do something"), i);
      jobs.push_back(testJob);
    }
    controller.addJobs(jobs);
    controller.recjobs(argv[1], argv[2]);
    {
      Info info("io_service");
      io_service.run();
    }
    Exitflag = controller.getExitflag();
  }
  catch (std::exception& e)
  {
    std::cerr << e.what() << std::endl;
  }

  return Exitflag;
}
