/*
 * Process.hpp
 *
 *  Created on: Feb 17, 2010
 *      Author: crueger
 */


/**
 * A Process is an action that might take some time and therfore contains methods
 * that allows showing how much is done.
 */
#ifndef PROCESS_HPP_
#define PROCESS_HPP_

#include <set>

#include "Patterns/Observer.hpp"
#include "Actions/Action.hpp"

class Process : public Action, public Observable
{
public:
  Process(int _maxSteps, std::string _name, bool _doRegister=true);
  virtual ~Process();

  bool  isActive();
  bool  doesStart();
  bool  doesStop();
  int   getCurrStep();
  void  setCurrStep(int _currStep);
  float getDoneRatio();
  int   getMaxSteps();
  void  setMaxSteps(int _maxSteps);

protected:
  void start();
  void step();
  void stop();

private:
  int currStep;
  int maxSteps;
  bool active;
  bool starts;
  bool stops;

  // some global static stuff to allow general Observers that can show progresses
public:
  static void AddObserver(Observer *);
  static void RemoveObserver(Observer *);
private:
  static std::set<Observer*> processObservers;
};

#endif /* PROCESS_HPP_ */
