/*
 * EigenvaluesUnitTest.hpp
 *
 *  Created on: Sep 27, 2013
 *      Author: heber
 */

#ifndef EIGENVALUESUNITTEST_HPP_
#define EIGENVALUESUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cppunit/extensions/HelperMacros.h>

#include "Fragmentation/Summation/SetValues/Eigenvalues.hpp"

/********************************************** Test classes **************************************/

class EigenvaluesTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( EigenvaluesTest) ;
    CPPUNIT_TEST ( equality_Test );
    CPPUNIT_TEST ( operatorPlusEqual_NonOverlapping_Test );
    CPPUNIT_TEST ( operatorPlusEqual_Test );
    CPPUNIT_TEST ( operatorMinusEqual_NonOverlapping_Test );
    CPPUNIT_TEST ( operatorMinusEqual_Test );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();
      void equality_Test();
      void operatorPlusEqual_NonOverlapping_Test();
      void operatorPlusEqual_Test();
      void operatorMinusEqual_NonOverlapping_Test();
      void operatorMinusEqual_Test();

private:
      Eigenvalues *ev;
      Eigenvalues::samples_t samples;
};

#endif /* EIGENVALUESUNITTEST_HPP_ */
