/*
 * SamplingGridPropertiesProperties_inline.hpp
 *
 *  Created on: 12.05.2013
 *      Author: heber
 */

#ifndef SAMPLINGGRIDPROPERTIES_INLINE_HPP_
#define SAMPLINGGRIDPROPERTIES_INLINE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "SamplingGridProperties.hpp"

#include <cmath>

#ifdef HAVE_INLINE
inline
#endif
const double SamplingGridProperties::getVolume() const
{
  double volume = 1.;
  for (size_t i=0;i<3;++i)
    volume *= end[i]-begin[i];
  return volume;
}

#ifdef HAVE_INLINE
inline
#endif
const size_t SamplingGridProperties::getTotalGridPoints() const
{
  return pow(getGridPointsPerAxis(),3);
}

#ifdef HAVE_INLINE
inline
#endif
const size_t SamplingGridProperties::getGridPointsPerAxis() const
{
  return pow(2, level);
}

#ifdef HAVE_INLINE
inline
#endif
const double SamplingGridProperties::getDeltaPerAxis(const size_t axis) const
{
  return getTotalLengthPerAxis(axis)/(double)getGridPointsPerAxis();
}

#ifdef HAVE_INLINE
inline
#endif
const double SamplingGridProperties::getTotalLengthPerAxis(const size_t axis) const
{
  return (end[axis] - begin[axis]);
}

#endif /* SAMPLINGGRIDPROPERTIES_INLINE_HPP_ */
