/*
 * Eigenvalues.hpp
 *
 *  Created on: Mar 8, 2013
 *      Author: heber
 */

#ifndef EIGENVALUES_HPP_
#define EIGENVALUES_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iosfwd>
#include <set>
#include <vector>

class Eigenvalues
{
  //!> grant unit test access to private parts
  friend class EigenvaluesTest;
  //!> grant output operator access
  friend std::ostream & operator<<(std::ostream &ost, const Eigenvalues &eigenvalues);
public:
  //!> named type for a vector of sample values
  typedef std::vector<double> samples_t;
public:
  /** Default constructor for class Eigenvalues.
   *
   */
  Eigenvalues()
  {}

  /** Constructor with a given vector of eigenvalues.
   *
   * \param _samples set of eigenvalues
   */
  Eigenvalues(const samples_t &_samples)
  {
    addedsamples.insert(_samples.begin(), _samples.end());
  }

  /** Default destructor for Eigenvalues.
   *
   */
  ~Eigenvalues()
  {}

  /** Adding another set of eigenvalues onto this one.
   *
   *
   * @param other other Eigenvalues
   * @return ref to this instance
   */
  Eigenvalues& operator+=(const Eigenvalues &other)
  {
    addedsamples.insert(other.addedsamples.begin(), other.addedsamples.end());
    subtractedsamples.insert(other.subtractedsamples.begin(), other.subtractedsamples.end());
    return *this;
  }

  /** Subtracting another set of eigenvalues from this one.
   *
   * @param other other Eigenvalues
   * @return ref to this instance
   */
  Eigenvalues& operator-=(const Eigenvalues &other);
//  {
//    subtractedsamples.insert(other.addedsamples.begin(), other.addedsamples.end());
//    return *this;
//  }

  /** Equality operator.
   *
   * @param other other instance to check against
   * @return true - both are equal, false - some eigenvalues differ
   */
  bool operator==(const Eigenvalues& other) const;

  bool operator!=(const Eigenvalues& other) const
  {
    return (!(*this == other));
  }

private:
  //!> typedef for the internal container format
  typedef std::set<double> sorted_samples_t;
  //!> internally we store a set of sorted samples
  sorted_samples_t addedsamples;
  sorted_samples_t subtractedsamples;
};

/** Function to print eigenvalues to ostream.
 *
 * @param ost output stream
 * @param eigenvalues set of eigenvalues to print
 * @return ref to given ostream for concatenation
 */
std::ostream & operator<<(std::ostream &ost, const Eigenvalues &eigenvalues);

template<typename T> T ZeroInstance();
template<> Eigenvalues ZeroInstance<Eigenvalues>();

#endif /* EIGENVALUES_HPP_ */
