/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2013 University of Bonn. All rights reserved.
 * Copyright (C)  2013 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Eigenvalues.cpp
 *
 *  Created on: Mar 8, 2013
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Eigenvalues.hpp"

#include <algorithm>
#include <iostream>
#include <vector>

//Eigenvalues& Eigenvalues::operator+=(const Eigenvalues &other) {
//  {
//    samples_t samples(other.addedsamples.begin(), other.addedsamples.end());
//    samples_t::iterator it =
//        std::set_difference(samples.begin(), samples.end(),
//            other.subtractedsamples.begin(), other.subtractedsamples.end(),
//            samples.begin());
//    samples.resize(it-samples.begin());
//    addedsamples.insert(samples.begin(), samples.end());
//  }
//  return *this;
//}
//
Eigenvalues& Eigenvalues::operator-=(const Eigenvalues &other) {
  {
    samples_t samples(other.addedsamples.begin(), other.addedsamples.end());
    samples_t::iterator it =
        std::set_difference(samples.begin(), samples.end(),
            other.subtractedsamples.begin(), other.subtractedsamples.end(),
            samples.begin());
    samples.resize(it-samples.begin());
    subtractedsamples.insert(samples.begin(), samples.end());
  }
  return *this;
}

std::ostream & operator<<(std::ostream &ost, const Eigenvalues &eigenvalues)
{
  // now subtract all eigenvalues stored in subtractedsamples from addedsamples
  {
    Eigenvalues::samples_t samples(eigenvalues.addedsamples.begin(), eigenvalues.addedsamples.end());
    Eigenvalues::samples_t::iterator it =
        std::set_difference(samples.begin(), samples.end(),
            eigenvalues.subtractedsamples.begin(), eigenvalues.subtractedsamples.end(),
            samples.begin());
    samples.resize(it-samples.begin());

    for (Eigenvalues::samples_t::const_iterator iter = samples.begin();
        iter != samples.end(); ++iter)
      ost << "(" << *iter << ",1.) ";
  }
//  {
//    Eigenvalues::samples_t samples(eigenvalues.subtractedsamples.begin(), eigenvalues.subtractedsamples.end());
//    Eigenvalues::samples_t::iterator it =
//        std::set_difference(samples.begin(), samples.end(),
//            eigenvalues.addedsamples.begin(), eigenvalues.addedsamples.end(),
//            samples.begin());
//    samples.resize(it-samples.begin());
//
//    for (Eigenvalues::samples_t::const_iterator iter = samples.begin();
//        iter != samples.end(); ++iter)
//      ost << "(" << *iter << ",1.5) ";
//  }
  return ost;
}

bool Eigenvalues::operator==(const Eigenvalues& other) const
{
  bool status = true;
  status &= addedsamples == other.addedsamples;
  status &= subtractedsamples == other.subtractedsamples;
  return status;
}

template<> Eigenvalues ZeroInstance<Eigenvalues>()
{
  Eigenvalues returnvalue;
  return returnvalue;
}
