/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * \file mpqc.cpp
 *
 * This file is for a stand-in for mpqc that just prints an output file (.out) which
 * is assumed to be present under the same path as the given input file (.in).
 *
 *  Created on: Apr 19, 2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <fstream>
#include <iostream>
#include <string>

int main(int argc, char **argv)
{
  // check arguments
  if (argc < 2) {
    std::cout << argv[0] << ": error: no molecule given" << std::endl;
    return 134;
  }
  // read given file, first line contains output file
  std::ifstream infile(argv[1]);
  std::string outfilename;
  getline(infile, outfilename);

  // try to open file
  std::ifstream file(outfilename.c_str());
  if (file.good()) {
    // print file's contents
    std::string line;
    while (getline(file,line))
      std::cout << line << std::endl;

    return 0;
  } else {
    std::cout << argv[0] << ": error: no output file found" << std::endl;
    return 134;
  }
}

