/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Inserter.cpp
 *
 *  Created on: Feb 21, 2012
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Inserter.hpp"

#include "InserterBase.hpp"

/** Constructor for class Inserter.
 *
 * @param _impl implementation to wrap
 */
Inserter::Inserter(Inserter::impl_ptr _impl) :
    impl(_impl)
{}

/** Copy Constructor for class Inserter.
 *
 */
Inserter::Inserter(const Inserter &ptr) :
    impl(ptr.getImpl())
{}

/** Destructor for class Inserter.
 *
 */
Inserter::~Inserter()
{}

bool Inserter::operator()(ClusterInterface::Cluster_impl cluster, const Vector &offset) const
{
  return impl->operator()(cluster, offset);
}

Inserter::impl_ptr Inserter::getImpl() const {
  return impl;
}
