/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * pyMoleCuilder.cpp
 *
 *  Created on: Sep 21, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/python.hpp>
#include <boost/python/module.hpp>
#include <boost/python/args.hpp>

#include "CodePatterns/MemDebug.hpp"

//!> define all present actions
#include "GlobalListOfActions.hpp"

//!> python wrapping for all of these actions
#include "AllActionPython.hpp"

#include "cleanUp.hpp"
#include "Actions/ActionHistory.hpp"


BOOST_PYTHON_MODULE(pyMoleCuilder)
{
  // need to init the history before any action is created
  MoleCuilder::ActionHistory::init();

  // from this moment on, we need to be sure to deeinitialize in the correct order
  // this is handled by the cleanup function
  atexit(cleanUp);

  // set the docstring of the current module scope
  boost::python::scope().attr("__doc__") = "pyMolecuilder are the python bindings to all Actions of the program suite MoleCuilder.\n\nMoleCuilder is a program to build molecular (dynamics) worlds, allowing you indefinite manipulation, control and analysis over the atoms and molecules within a simulation domain.";

#define export_print(z,n,list) \
	BOOST_PP_CAT(export_, BOOST_PP_SEQ_ELEM(n, list))();
#define BOOST_PP_LOCAL_MACRO(n) export_print(~, n, GLOBALLISTOFACTIONS)
#define BOOST_PP_LOCAL_LIMITS  (0, BOOST_PP_DEC(BOOST_PP_SEQ_SIZE(GLOBALLISTOFACTIONS)))
#include BOOST_PP_LOCAL_ITERATE()
#undef instance_print  
}
