/*
 * Extractors.hpp
 *
 *  Created on: 15.10.2012
 *      Author: heber
 */

#ifndef TRAININGDATA_EXTRACTORS_HPP_
#define TRAININGDATA_EXTRACTORS_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Fragmentation/SetValues/Fragment.hpp"
#include "FunctionApproximation/FunctionModel.hpp"

class Fragment;

/** Namespace containing all simple extractor functions.
 *
 */
namespace Extractors {
  /** Namespace for some internal helper functions.
   *
   */
  namespace _detail {
    /** Gather all distances from a given set of positions.
     *
     * \param positins vector of positions
     * \param globalid index to associated in argument_t with
     * \return vector of argument_ , each with a distance
     */
    FunctionModel::arguments_t
    gatherAllDistanceArguments(
        const Fragment::positions_t &positions,
        const size_t globalid);
  }

  /** Simple extractor of all unique pair distances of a given \a fragment.
   *
   * \param fragment fragment with all nuclei positions
   * \param index index refers to the index within the global set of configurations
   * \return vector of of argument_t containing all found distances
   */
  inline FunctionModel::arguments_t gatherAllDistances(
      const Fragment& fragment,
      const size_t index
      ) {
    // get distance out of Fragment
    return _detail::gatherAllDistanceArguments(fragment.getPositions(), index);
  }

  /** Gather first distance for the two matching charges.
   *
   * \param fragment fragment with all nuclei positions
   * \param index index refers to the index within the global set of configurations
   * \param firstelement first element of pair
   * \param secondelement second element of pair, order is reflected in indices of return argument_t
   * \return vector of of argument_t containing all found distances
   */
  FunctionModel::arguments_t gatherFirstDistance(
      const Fragment& fragment,
      const size_t index,
      const size_t firstelement,
      const size_t secondelement
      );

}; /* namespace Extractors */


#endif /* TRAININGDATA_EXTRACTORS_HPP_ */
