/** \file menu.hpp
 * The class in this file is responsible for displaying the menu and enabling choices.
 *
 * This class is currently being refactored. Functions were copied from builder.cpp and are
 * to be imported into the menu class.
 *
 */

#ifndef MENU_H_
#define MENU_H_


class MoleculeListClass;
class periodentafel;
class config;
class molecule;

class menu
{
public:
  menu();
  virtual ~menu();

  void perform(MoleculeListClass *, config *, periodentafel *, char *);
  void SaveConfig(char *, config *, periodentafel *, MoleculeListClass *);

protected:
  void AddAtoms(periodentafel *, molecule *);
  void AlignAtoms(periodentafel *, molecule *);
  void CenterAtoms(molecule *);
  void EditMolecules(periodentafel *, MoleculeListClass *);
  void FragmentAtoms(molecule *, config *);
  void ManipulateAtoms(periodentafel *, MoleculeListClass *, config *);
  void MeasureAtoms(periodentafel *, molecule *, config *);
  void MergeMolecules(periodentafel *, MoleculeListClass *);
  void ManipulateMolecules(periodentafel *, MoleculeListClass *, config *);
  void MirrorAtoms(molecule *);
  void RemoveAtoms(molecule *);
  void testroutine(MoleculeListClass *);
};

#endif /* MENU_H_ */
