/*
 * SetValue.hpp
 *
 *  Created on: Jun 25, 2012
 *      Author: heber
 */

#ifndef SETVALUE_HPP_
#define SETVALUE_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "IndexSet.hpp"

#include "CodePatterns/Observer/Observable.hpp"

template <class T>
class SetValue : public Observable
{
public:
  SetValue(const IndexSet &_indices, const T &_value) :
    Observable("SubsetValue"),
    value(_value),
    indices(_indices)
  {};

  SetValue & operator+=(const SetValue &other) {
    if (indices.contains(other.indices))
      value += other.value;
    return *this;
  }

  SetValue & operator-=(const SetValue &other) {
    if (indices.contains(other.indices))
      value -= other.value;
    return *this;
  }

  const IndexSet& getIndexSet() const {
    return indices;
  }

  const T getValue() const {
    return value;
  }

  void setValue(const T& _value) {
    OBSERVE;
    value = _value;
  }

private:
  // prohibit copies
  SetValue(const SetValue<T> &_value);

private:
  //!> value associated with this IndexSet
  T value;

  //!> reference to the index set
  const IndexSet &indices;
};


#endif /* SETVALUE_HPP_ */
