/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ChangeBoxAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include headers that implement a archive in simple text format
#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>
#include "boost/serialization/vector.hpp"

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "LinearAlgebra/MatrixContent.hpp"
#include "LinearAlgebra/RealSpaceMatrix.hpp"
#include "World.hpp"
#include "Box.hpp"

#include <iostream>
#include <string>

#include "Actions/WorldAction/ChangeBoxAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "ChangeBoxAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr WorldChangeBoxAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  // create undo state
  std::stringstream undostream;
  boost::archive::text_oarchive oa(undostream);
  const RealSpaceMatrix &matrix = World::getInstance().getDomain().getM();
  oa << matrix;

  World::getInstance().setDomain(params.cell_size.getM()); // this is needed as only this function is OBSERVEd.

  // give final box size
  LOG(0, "Box domain is now " << World::getInstance().getDomain().getM());

  // create undo state
  WorldChangeBoxState *UndoState =
      new WorldChangeBoxState(
          undostream.str(),
          params
          );

  return Action::state_ptr(UndoState);
}

Action::state_ptr WorldChangeBoxAction::performUndo(Action::state_ptr _state) {
  WorldChangeBoxState *state = assert_cast<WorldChangeBoxState*>(_state.get());

  // restore domain
  RealSpaceMatrix matrix;
  std::stringstream undostream(state->undostring);
  boost::archive::text_iarchive ia(undostream);
  ia >> matrix;
  World::getInstance().setDomain(matrix);

  // give final box size
  LOG(0, "Box domain restored to " << World::getInstance().getDomain().getM());

  return Action::state_ptr(_state);
}

Action::state_ptr WorldChangeBoxAction::performRedo(Action::state_ptr _state){
  World::getInstance().setDomain(params.cell_size.getM()); // this is needed as only this function is OBSERVEd.

  // give final box size
  LOG(0, "Box domain is again " << World::getInstance().getDomain().getM());

  return Action::state_ptr(_state);
}

bool WorldChangeBoxAction::canUndo() {
  return true;
}

bool WorldChangeBoxAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
