/*
 * TextDialog.hpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

#ifndef TEXTDIALOG_HPP_
#define TEXTDIALOG_HPP_

#include <string>

#include "UIElements/Dialog.hpp"

class TextDialog : public Dialog
{
public:
  TextDialog();
  virtual ~TextDialog();

  virtual void queryInt(const char *, int *);
  virtual void queryString(const char*, std::string *);
  virtual void queryMolecule(const char*,molecule**,MoleculeListClass*);

protected:
  // specialized stuff for text queries
  class IntTextQuery : public Dialog::IntQuery {
  public:
    IntTextQuery(std::string title, int *_target);
    ~IntTextQuery();
    virtual bool handle();
  };

  class StringTextQuery : public Dialog::StringQuery {
  public:
    StringTextQuery(std::string title, std::string *_target);
    ~StringTextQuery();
    virtual bool handle();
  };

  class MoleculeTextQuery : public Dialog::MoleculeQuery {
  public:
    MoleculeTextQuery(std::string title, molecule **_target, MoleculeListClass *_molecules);
    ~MoleculeTextQuery();
    virtual bool handle();
  };
};

#endif /* TEXTDIALOG_HPP_ */
