/*
 * Dialog.hpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

#ifndef DIALOG_HPP_
#define DIALOG_HPP_

#include<string>
#include<list>

class MoleculeListClass;
class molecule;

class Dialog
{
public:
  Dialog();
  virtual ~Dialog();

  virtual void queryInt(const char *, int *)=0;
  virtual void queryString(const char*, std::string *)=0;
  virtual void queryMolecule(const char*,molecule**,MoleculeListClass*)=0;

  virtual bool display();

protected:
  // methodology for handling queries
  // all queries are stored and then performed at appropriate times

  //these queries can be handled by this dialog

  //TODO: Find a way to reduce complexity...
  //needs O(N*M) query classes, where N is the number of query types and M is the number of GUIs
  //usual approach for reducing inheritance complexity (strategy pattern) does not work,
  //due to lack of common code for query types as well as GUI-Types (all subtypes differ a lot)

  //base class for all queries
  class Query {
  public:
    Query(std::string _title);
    ~Query();
    virtual bool handle()=0;
    virtual void setResult()=0;
  protected:
    const std::string getTitle() const;
  private:
    std::string title;
  };

  //Specialized classes for certain types. GUI-Types are not specialized at this time
  class IntQuery : public Query {
  public:
    IntQuery(std::string title,int *_target);
    ~IntQuery();
    virtual bool handle()=0;
    virtual void setResult();
  protected:
    int tmp;
  private:
    int *target;
  };

  class StringQuery : public Query {
  public:
    StringQuery(std::string title,std::string *_target);
    ~StringQuery();
    virtual bool handle()=0;
    virtual void setResult();
  protected:
    std::string tmp;
  private:
    std::string *target;
  };

  class MoleculeQuery : public Query {
  public:
    MoleculeQuery(std::string title, molecule **_target, MoleculeListClass *_molecules);
    ~MoleculeQuery();
    virtual bool handle()=0;
    virtual void setResult();
  protected:
    molecule *tmp;
    MoleculeListClass *molecules;
  private:
    molecule **target;
  };

void registerQuery(Query* query);

private:
  std::list<Query*> queries;

};

#endif /* DIALOG_HPP_ */
