/** \file FormatParserStorage.hpp
 *
 *  date: Jun, 22 2010
 *  author: heber
 *
 */

#ifndef FORMATPARSERSTORAGE_HPP_
#define FORMATPARSERSTORAGE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/Singleton.hpp"

#include <string>
#include <map>
#include <vector>

#include "Parser/FormatParser.hpp"
#include "Parser/MpqcParser.hpp"
#include "Parser/PcpParser.hpp"
#include "Parser/PdbParser.hpp"
#include "Parser/TremoloParser.hpp"
#include "Parser/XyzParser.hpp"

class atom;

// enum has to be outside of class for operator++ to be possible
enum ParserTypes { mpqc, pcp, pdb, tremolo, xyz, ParserTypes_end, ParserTypes_begin = mpqc };
typedef enum ParserTypes ParserTypes;

ParserTypes &operator++(ParserTypes &type);

class FormatParserStorage : public Singleton<FormatParserStorage> {
  friend class Singleton<FormatParserStorage>;
public:

  void addMpqc();
  void addPcp();
  void addPdb();
  void addTremolo();
  void addXyz();
  bool add(std::string type);
  bool add(ParserTypes type);

  bool load(std::istream &input, std::string suffix);
  bool save(std::ostream &output, std::string suffix, const std::vector<atom *> &atoms);
  bool saveSelectedAtoms(std::ostream &output, std::string suffix);
  bool saveSelectedMolecules(std::ostream &output, std::string suffix);
  bool saveWorld(std::ostream &output, std::string suffix);
  MpqcParser &getMpqc();
  PcpParser &getPcp();
  PdbParser &getPdb();
  TremoloParser &getTremolo();
  XyzParser &getXyz();
  FormatParser &get(enum ParserTypes _type);

  ParserTypes getTypeFromName(std::string type);
  ParserTypes getTypeFromSuffix(std::string type);

  void SetOutputPrefixForAll(std::string &_prefix);
  void SaveAll();

private:
  // private constructors as this is a singleton
  FormatParserStorage();
  ~FormatParserStorage();
  
  // list of allocated parsers
  std::vector<FormatParser *> ParserList;

  // list of allocated strams
  std::vector<std::ofstream *> ParserStream;

  // which parser is already present
  std::vector<bool> ParserPresent;

  // default suffix of each parser type
  std::map<ParserTypes, std::string> ParserSuffixes;
  std::map<std::string, ParserTypes> ParserLookupSuffixes;

  // function pointers to each add...()
  std::map< ParserTypes, void (FormatParserStorage::*)() > ParserAddFunction;

  // type name of each parser type and reverse lookup
  std::map<ParserTypes, std::string> ParserNames;
  std::map<std::string, ParserTypes> ParserLookupNames;


  // prefix of the filenames to use on save
  std::string prefix;
};

#endif // FORMATPARSERSTORAGE_HPP_
