/*
 * Exceptions.hpp
 *
 *  Created on: Apr 1, 2011
 *      Author: heber
 */

#ifndef EXCEPTIONS_HPP_
#define EXCEPTIONS_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <exception>
#include <boost/exception.hpp>

class MatrixContent;
class Vector;

struct LinearAlgebraException : virtual std::exception, virtual boost::exception { };

/** ========================== General error information ================== */

/** Exception information for LinearAlgebraException: determinant.
 */
typedef boost::error_info<struct tag_LinearAlgebraDeterminant, const double> LinearAlgebraDeterminant;

/** Exception information for LinearAlgebraException: matrix.
 */
typedef boost::error_info<struct tag_LinearAlgebraMatrixContent, const MatrixContent* const> LinearAlgebraMatrixContent;

/** Exception information for LinearAlgebraException: vector.
 */
typedef boost::error_info<struct tag_LinearAlgebraVector, const Vector* const> LinearAlgebraVector;

/** Exception information for LinearAlgebraException: vector.
 */
typedef boost::error_info<
    struct tag_LinearAlgebraVectorPair,
    const std::pair<const Vector* const, const Vector* const> > LinearAlgebraVectorPair;

/** ============================ Specific exceptions ====================== */

/** Exception thrown when two vectors are parallel, i.e. linear dependent.
 */
struct LinearDependenceException : virtual LinearAlgebraException { };

/** Exception thrown when are matrix is not invertiable, i.e. its determinant is NULL.
 */
struct MultipleSolutionsException : virtual LinearAlgebraException { };

/** Exception thrown when are matrix is not invertiable, i.e. its determinant is NULL.
 */
struct NotInvertibleException : virtual LinearAlgebraException { };

/** Exception thrown when two lines are skew, i.e. do not intersect.
 */
struct SkewException : virtual LinearAlgebraException { };

/** Exception thrown when a vector with only zero components is invalidly encountered.
 */
struct ZeroVectorException : virtual LinearAlgebraException { };

#endif /* EXCEPTIONS_HPP_ */
