#ifndef BOUNDARY_HPP_
#define BOUNDARY_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <fstream>
#include <iostream>

// STL headers
#include <map>

#include "defs.hpp"

/****************************************** forward declarations *****************************/

class atom;
class BoundaryPointSet;
class BoundaryLineSet;
class BoundaryTriangleSet;
class config;
class LinkedCell;
class molecule;
class MoleculeListClass;
class Tesselation;
class Vector;

/********************************************** definitions *********************************/

#define DEBUG 1
#define DoSingleStepOutput 0
#define SingleStepWidth 10

#define DistancePair pair < double, atom* >
#define DistanceMap multimap < double, atom* >
#define DistanceTestPair pair < DistanceMap::iterator, bool>

#define Boundaries map <double, DistancePair >
#define BoundariesPair pair<double, DistancePair >
#define BoundariesTestPair pair< Boundaries::iterator, bool>

/********************************************** declarations *******************************/

double ConvexizeNonconvexEnvelope(class Tesselation *&TesselStruct, const molecule * const mol, const char * const filename);
molecule * FillBoxWithMolecule(MoleculeListClass *List, molecule *filler, config &configuration, const double distance[NDIM], const double epsilon, const double RandomAtomDisplacement, const double RandomMolDisplacement, const bool DoRandomRotation);
void FindConvexBorder(const molecule* const mol, Tesselation *&TesselStruct, const LinkedCell *LCList, const char *filename);
Vector* FindEmbeddingHole(MoleculeListClass *mols, molecule *srcmol);
void FindNextSuitablePoint(class BoundaryTriangleSet *BaseTriangle, class BoundaryLineSet *BaseLine, atom*& OptCandidate, Vector *OptCandidateCenter, double *ShortestAngle, const double RADIUS, LinkedCell *LC);
bool FindNonConvexBorder(const molecule* const mol, Tesselation *&TesselStruct, const LinkedCell *&LC, const double RADIUS, const char *tempbasename);
Boundaries *GetBoundaryPoints(const molecule *mol, Tesselation *&TesselStruct);
double * GetDiametersOfCluster(const Boundaries *BoundaryPtr, const molecule *mol, Tesselation *&TesselStruct, const bool IsAngstroem);
void PrepareClustersinWater(config *configuration, molecule *mol, double ClusterVolume, double celldensity);
bool RemoveAllBoundaryPoints(class Tesselation *&TesselStruct, const molecule * const mol, const char * const filename);
void StoreTrianglesinFile(const molecule * const mol, const Tesselation * const TesselStruct, const char *filename, const char *extraSuffix);
double VolumeOfConvexEnvelope(class Tesselation *TesselStruct, class config *configuration);


#endif /*BOUNDARY_HPP_*/
