/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * VectorNotZeroValidator.cpp
 *
 *  Created on: Jul 10, 2012
 *      Author: ankele
 */



// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "VectorNotZeroValidator.hpp"

#include "LinearAlgebra/RealSpaceMatrix.hpp"

bool VectorNotZeroValidator::isValid(const Vector & _value) const
{
  return !_value.IsZero();
}

bool VectorNotZeroValidator::operator==(const Validator<Vector> &_instance) const
{
  const VectorNotZeroValidator *inst =
      dynamic_cast<const VectorNotZeroValidator *>(&_instance);
  if (inst)
    return true;
  else
    return false;
}

Validator< Vector >* VectorNotZeroValidator::clone() const
{
  Validator< Vector > *inst =
      new VectorNotZeroValidator();
  return inst;
}




