/*
 * SyncOperation.hpp
 *
 *  Created on: Mar 04, 2012
 *      Author: heber
 */

#ifndef FRAGMENTCONTROLLER_SYNCOPERATION_HPP_
#define FRAGMENTCONTROLLER_SYNCOPERATION_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/asio.hpp>
#include <string>
#include <vector>

#include "Operation.hpp"

class SyncOperation : public Operation {
public:
  /** Constructor for class SyncOperation.
   *
   * \param _name name for this Operation for retrieval from a registry
   * \param _connection connection to operate on
   */
  SyncOperation(const std::string &_name, Connection &_connection) :
    Operation(_name, _connection)
  {}

  /** Destructor for class SyncOperation.
   *
   */
  virtual ~SyncOperation()
  {}

public:
  // virtual function pointer to the operation to do
  void operator()(const std::string& _host, const std::string& _service);

protected:
  // function that implements read&writes in between connect/disconnect
  virtual void internal() = 0;

  // internal function to connect to server
  void connect(const std::string& _host, const std::string& _service);

  /// internal function to disconnect from server
  void disconnect();
};

#endif /* FRAGMENTCONTROLLER_SYNCOPERATION_HPP_ */
