/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * SyncOperation.cpp
 *
 *  Created on: Mar 04, 2012
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// boost asio needs specific operator new
#include <boost/asio.hpp>

#include "CodePatterns/MemDebug.hpp"

#include <boost/bind.hpp>
#include <vector>
#include "Connection.hpp" // Must come before boost/serialization headers.
#include "CodePatterns/Info.hpp"
#include "CodePatterns/Log.hpp"

#include "Controller/Commands/SyncOperation.hpp"

/** Internal function to connect connection_.
 *
 */
void SyncOperation::connect(const std::string& _host, const std::string& _service)
{
  // Resolve the host name into an IP address.
  boost::asio::ip::tcp::resolver resolver(connection_.socket().get_io_service());
  boost::asio::ip::tcp::resolver::query query(_host, _service);
  boost::asio::ip::tcp::resolver::iterator endpoint_iterator =
    resolver.resolve(query);
  boost::asio::ip::tcp::endpoint endpoint = *endpoint_iterator;

  // Start an asynchronous connect operation.
  std::cout << "Connecting to endpoint " << endpoint << " ..." << std::endl;
  connection_.socket().connect(endpoint);
}


/** Internal function to disconnect connection_ correctly.
 *
 */
void SyncOperation::disconnect()
{
  connection_.socket().close();
}

/** Wrapper function for the virtual call to internal() that connects and disconnects.
 *
 * @param _host host address to connect to
 * @param _service service to connect to
 */
void SyncOperation::operator()(const std::string& _host, const std::string& _service)
{
  LOG(1, "INFO: Commencing operation ...");

  // connect
  connect(_host, _service);

  // call virtual function to continue
  internal();

  // disconnect
  disconnect();

  LOG(1, "INFO: Operation completed.");
}
