/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ShutdownOperation.cpp
 *
 *  Created on: Feb 28, 2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// boost asio needs specific operator new
#include <boost/asio.hpp>

#include "CodePatterns/MemDebug.hpp"

#include <boost/bind.hpp>
#include <iostream>
#include "Connection.hpp" // Must come before boost/serialization headers.
#include "CodePatterns/Info.hpp"
#include "ControllerChoices.hpp"

#include "Controller/Commands/ShutdownOperation.hpp"

/** Virtual internal function to give shutdown choice.
 *
 */
void ShutdownOperation::internal()
{
  Info info(__FUNCTION__);
  enum ControllerChoices choice = ShutdownControllerSocket;
  connection_.sync_write(choice);
}

