/*
 * ShutdownOperation.hpp
 *
 *  Created on: Dec 11, 2011
 *      Author: heber
 */

#ifndef FRAGMENTCONTROLLER_SHUTDOWNOPERATION_HPP_
#define FRAGMENTCONTROLLER_SHUTDOWNOPERATION_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/asio.hpp>
#include <string>
#include <vector>

#include "Connection.hpp"

#include "Controller/Commands/SyncOperation.hpp"

/** Synchronous operation that gives shutdown command.
 *
 */
class ShutdownOperation : public SyncOperation  {
public:
  /// Constructor for class ShutdownOperation.
  ShutdownOperation(Connection &_connection) :
    SyncOperation(std::string("shutdown"),_connection) {}
  /// Destructor for class ShutdownOperation
  ~ShutdownOperation() {}

public:
  // function that implements read&writes in between connect/disconnect
  virtual void internal();
};

#endif /* FRAGMENTCONTROLLER_SHUTDOWNOPERATION_HPP_ */
