/*
 * AsyncOperation.hpp
 *
 *  Created on: Nov 11, 2011
 *      Author: heber
 */

#ifndef FRAGMENTCONTROLLER_ASYNCOPERATION_HPP_
#define FRAGMENTCONTROLLER_ASYNCOPERATION_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/asio.hpp>
#include <string>
#include <vector>

#include "Operation.hpp"

class AsyncOperation : public Operation {
public:
  /** Constructor for class AsyncOperation.
   *
   * \param _name name for this AsyncOperation for retrieval from a registry
   * \param _connection connection to operate on
   */
  AsyncOperation(const std::string &_name, Connection &_connection) :
    Operation(_name, _connection)
  {}

  /** Destructor for class AsyncOperation.
   *
   */
  virtual ~AsyncOperation()
  {}

public:
  // virtual function pointer to the operation to do
  void operator()(const std::string& _host, const std::string& _service);

protected:
  // virtual function pointer to the connection handler
  virtual void handle_connect(const boost::system::error_code& e,
      boost::asio::ip::tcp::resolver::iterator endpoint_iterator) = 0;

  /// Handle completion of an operation.
  void handle_FinishOperation(const boost::system::error_code& e);

protected:
  /// internal function to disconnect from server
  void disconnect();
};

#endif /* FRAGMENTCONTROLLER_ASYNCOPERATION_HPP_ */
