/*
 * DummyUI.h
 *
 *  Created on: Jul 29, 2010
 *      Author: crueger
 */

#ifndef DUMMYUI_H_
#define DUMMYUI_H_

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"

class DummyDialog : public Dialog
{
public:
  DummyDialog(){}
  virtual ~DummyDialog(){}

  virtual void queryEmpty(const char *, std::string = ""){}
  virtual void queryBoolean(const char *, std::string = ""){}
  virtual void queryInt(const char *, std::string = ""){}
  virtual void queryInts(const char *, std::string = ""){}
  virtual void queryString(const char*, std::string = ""){}
  virtual void queryStrings(const char*, std::string = ""){}
  virtual void queryDouble(const char*, std::string = ""){}
  virtual void queryDoubles(const char*, std::string = ""){}
  virtual void queryAtom(const char*,std::string = ""){}
  virtual void queryAtoms(const char*,std::string = ""){}
  virtual void queryMolecule(const char*,std::string = ""){}
  virtual void queryMolecules(const char*,std::string = ""){}
  virtual void queryVector(const char*,bool, std::string = ""){}
  virtual void queryVectors(const char*,bool, std::string = ""){}
  virtual void queryBox(const char*, std::string = ""){}
  virtual void queryElement(const char*, std::string = ""){}
  virtual void queryElements(const char*, std::string = ""){}
  virtual void queryFile(const char*, std::string = ""){}
};

class DummyUIFactory : public UIFactory
{
public:
  virtual ~DummyUIFactory(){}

  virtual Dialog* makeDialog(){return new DummyDialog;}
  virtual MainWindow* makeMainWindow(){return 0;}

  struct description : public UIFactory::factoryDescription {
    description():
        UIFactory::factoryDescription("Dummy")
    {}
    virtual ~description(){}

    virtual UIFactory* makeFactory(){return new DummyUIFactory;};
  };

protected:
  DummyUIFactory(){}
};

#endif /* DUMMYUI_H_ */
