/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * InputAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Helpers/Log.hpp"
#include "molecule.hpp"
#include "Parser/FormatParserStorage.hpp"
#include "Parser/PcpParser.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

#include <boost/filesystem/fstream.hpp>

using namespace std;

#include "Actions/WorldAction/InputAction.hpp"

// and construct the stuff
#include "InputAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr WorldInputAction::performCall() {
//  MoleculeListClass *molecules = World::getInstance().getMolecules();
//  molecule *mol = NULL;
  boost::filesystem::ifstream test;

  // obtain information
  getParametersfromValueStorage();

  DoLog(0) && (Log() << Verbose(0) << "Config file given " << params.filename << "." << endl);
  if (!boost::filesystem::exists(params.filename)) {
    DoLog(1) && (Log() << Verbose(1) << "Specified config file " << params.filename << " not found." << endl);
    return Action::failure;
  } else {
    DoLog(1) && (Log() << Verbose(1) << "Specified config file found, parsing ... ");
    if (params.filename.has_filename()) {
      // get suffix
      std::string FilenameSuffix = params.filename.extension();
      std::string FilenamePrefix = params.filename.stem();
      DoLog(1) && (Log() << Verbose(1) << "Setting config file name prefix to " << FilenamePrefix << "." << endl);
      FormatParserStorage::getInstance().SetOutputPrefixForAll(FilenamePrefix);

      // parse the file
      test.open(params.filename);
      FormatParserStorage::getInstance().get(test, FilenameSuffix);
      test.close();
//
//      // set mol to first active molecule
//      if (molecules->ListOfMolecules.size() != 0) {
//        for (MoleculeList::iterator ListRunner = molecules->ListOfMolecules.begin(); ListRunner != molecules->ListOfMolecules.end(); ListRunner++)
//          if ((*ListRunner)->ActiveFlag) {
//            mol = *ListRunner;
//            break;
//          }
//      }
//      if (mol == NULL) {
//        mol = World::getInstance().createMolecule();
//        mol->ActiveFlag = true;
//        molecules->insert(mol);
//      }
//      mol->SetNameFromFilename(params.filename.substr(0,params.filename.find('.')).c_str());
      return Action::success;
    } else {
      DoeLog(1) && (eLog() << Verbose(1) << "Input file does not have a suffix, cannot recognize format." << endl);
      return Action::failure;
    }
  }
}

Action::state_ptr WorldInputAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr WorldInputAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool WorldInputAction::canUndo() {
  return false;
}

bool WorldInputAction::shouldUndo() {
  return false;
}

const string WorldInputAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
