/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * UniqueFragments.cpp
 *
 *  Created on: Oct 18, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "UniqueFragments.hpp"

#include "CodePatterns/Log.hpp"

#include "Atom/atom.hpp"
#include "Bond/bond.hpp"
#include "Element/element.hpp"
#include "Fragmentation/fragmentation_helpers.hpp"
#include "Fragmentation/Graph.hpp"
#include "Fragmentation/KeySet.hpp"

/** Constructor of class UniqueFragments.
 *
 */
UniqueFragments::UniqueFragments()
{}

/** Destructor of class UniqueFragments.
 *
 */
UniqueFragments::~UniqueFragments()
{}

/** Checking whether KeySet is not already present in Graph, if so just adds factor.
 */
void UniqueFragments::InsertFragmentIntoGraph()
{
  GraphTestPair testGraphInsert;

  testGraphInsert = Leaflet->insert(GraphPair (*FragmentSet,std::pair<int,double>(FragmentCounter,TEFactor)));  // store fragment number and current factor
  if (testGraphInsert.second) {
    LOG(2, "KeySet " << FragmentCounter << " successfully inserted.");
    FragmentCounter++;
  } else {
    LOG(2, "KeySet " << FragmentCounter << " failed to insert, present fragment is " << ((*(testGraphInsert.first)).second).first);
    ((*(testGraphInsert.first)).second).second += TEFactor;  // increase the "created" counter
    LOG(2, "New factor is " << ((*(testGraphInsert.first)).second).second << ".");
  }
};

/** Initialization for UniqueFragments.
 *
 * \param _Root ref to atom to start from (with graph algorithms, hence root node)
 * \param AtomCount number of nodes/atoms
 */
void UniqueFragments::Init(atom *_Root)
{
  // initialise the fragments structure
  FragmentCounter = 0;
  FragmentSet = new KeySet;
  Root = _Root;
}

/** Removes some allocated memory.
 *
 */
void UniqueFragments::Cleanup()
{
  delete(FragmentSet);
}

/** Getter for UniqueFragments:Root.
 *
 * @return const ref to root atom.
 */
atom * const UniqueFragments::getRoot() const
{
  return Root;
}

/** Setter for UniqueFragments:Root.
 *
 * @param _root root atom to set
 */
void UniqueFragments::setRoot(atom *_root)
{
  Root=_root;
}

/** Sets initial values before PowerSetGenerator uses this class.
 *
 * @param _TEFactor total energy factor
 * @param _Leaflet current graph to work on
 * @param _Root root atom
 */
void UniqueFragments::PrepareForPowersetGeneration(double _TEFactor, Graph *_Leaflet, atom *_Root)
{
  TEFactor = _TEFactor;
  Leaflet = _Leaflet;
  Root = _Root;
}
