/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * SetMpqcParametersAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Parser/FormatParserStorage.hpp"
#include "Parser/MpqcParser.hpp"
#include "Parser/MpqcParser_Parameters.hpp"

#include <iostream>
#include <string>

#include "SetMpqcParametersAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "SetMpqcParametersAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr ParserSetMpqcParametersAction::performCall() {
  MpqcParser_Parameters &mpqc = FormatParserStorage::getInstance().getParser<MpqcParser>().getParams();

  std::stringstream oldparamstream;
  oldparamstream << mpqc;
  // obtain information
  getParametersfromValueStorage();
  std::stringstream newparamstream(params.newparams);
  newparamstream >> mpqc;

  return Action::state_ptr(new ParserSetMpqcParametersState(oldparamstream.str(), params));
}

Action::state_ptr ParserSetMpqcParametersAction::performUndo(Action::state_ptr _state) {
  ParserSetMpqcParametersState *state = assert_cast<ParserSetMpqcParametersState*>(_state.get());

  MpqcParser_Parameters &mpqc = FormatParserStorage::getInstance().getParser<MpqcParser>().getParams();
  std::stringstream oldparamstream(state->oldparams);
  oldparamstream >> mpqc;

  return Action::state_ptr(_state);
}

Action::state_ptr ParserSetMpqcParametersAction::performRedo(Action::state_ptr _state){
  ParserSetMpqcParametersState *state = assert_cast<ParserSetMpqcParametersState*>(_state.get());

  MpqcParser_Parameters &mpqc = FormatParserStorage::getInstance().getParser<MpqcParser>().getParams();
  std::stringstream newparamstream(state->params.newparams);
  newparamstream >> mpqc;

  return Action::state_ptr(_state);
}

bool ParserSetMpqcParametersAction::canUndo() {
  return true;
}

bool ParserSetMpqcParametersAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
