/*
 * Action_impl_python.hpp
 *
 *  Created on: Sep 25, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/preprocessor/cat.hpp>
#include <boost/preprocessor/comparison/equal.hpp>
#include <boost/preprocessor/control/if.hpp>
#include <boost/preprocessor/control/expr_if.hpp>
#include <boost/preprocessor/debug/assert.hpp>
#include <boost/preprocessor/facilities/expand.hpp>
#include <boost/preprocessor/iteration/local.hpp>
#include <boost/preprocessor/punctuation/comma_if.hpp>

#define NODEFAULT ""

// some derived names: if CATEGORY is not given, we don't prefix with it
#ifdef CATEGORY
#define ACTION BOOST_PP_CAT(CATEGORY, BOOST_PP_CAT(ACTIONNAME, Action))
#define COMMAND BOOST_PP_CAT(CATEGORY, ACTIONNAME)
#define PARAMS BOOST_PP_CAT(CATEGORY, BOOST_PP_CAT(ACTIONNAME, Parameters))
#else
#define ACTION BOOST_PP_CAT(ACTIONNAME, Action)
#define COMMAND ACTIONNAME
#define PARAMS BOOST_PP_CAT(ACTIONNAME, Parameters)
#endif

// check if no lists given
#ifndef paramtokens
#define MAXPARAMTYPES 0
#else
#define MAXPARAMTYPES BOOST_PP_SEQ_SIZE(paramtokens)
#endif

// calculate numbers and check whether all have same size
#ifdef paramtokens
BOOST_PP_ASSERT_MSG(BOOST_PP_EQUAL(MAXPARAMTYPES, BOOST_PP_SEQ_SIZE(paramdescriptions)),\
  ERROR: There are not the same number of "paramtokens" and "paramdescriptions" in: __FILE__ \
)
#endif

// print a list of "action separator description linenend, i.e. "Action - descrption\n"
#define help_print(z,n,TYPELIST, VARLIST, separator, lineend) \
  BOOST_PP_IF(n, +, BOOST_PP_EMPTY()) \
  "\t" + std::string( BOOST_PP_SEQ_ELEM(n, TYPELIST) ) + \
  std::string( separator ) + \
  std::string( BOOST_PP_SEQ_ELEM(n, VARLIST) ) + \
  std::string( lineend )

// print a list of comma-separated list, i.e. (,)arg("Action")=default
#define stringdefault_print(z,n,STRINGLIST, DEFAULTLIST) \
  BOOST_PP_COMMA_IF(n) \
  boost::python::arg( \
  BOOST_PP_SEQ_ELEM(n, STRINGLIST) \
  ) \
  = BOOST_PP_SEQ_ELEM(n, DEFAULTLIST)

// print a list of comma-separated list, i.e. (,)arg("Action")
#define string_print(z,n,STRINGLIST) \
  BOOST_PP_COMMA_IF(n) \
  boost::python::arg( \
  BOOST_PP_SEQ_ELEM(n, STRINGLIST) \
  )

// print a list of type ref followed, i.e. "int i, double position"
#define type_list(z,n,TYPELIST, VARLIST) \
  BOOST_PP_COMMA_IF(n)\
  BOOST_PP_SEQ_ELEM(n, TYPELIST) \
  BOOST_PP_SEQ_ELEM(n, VARLIST)

// prints set/queryCurrentValue (command) for paramreferences and paramtokens
#define value_print(z,n,command, prefix) \
  ValueStorage::getInstance(). command (\
  BOOST_PP_SEQ_ELEM(n, paramtokens)\
  , \
  prefix\
  BOOST_PP_SEQ_ELEM(n, paramreferences)\
  );

#define stringtype std::string

#define type2string(s, data, elem) \
	stringtype

#include "Actions/Action.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Actions/ValueStorage.hpp"

namespace MoleCuilder {
#ifdef returntype
  returntype
#else
  void
#endif
BOOST_PP_CAT( COMMAND, _stringargs)(
#if defined paramtypes
#define BOOST_PP_LOCAL_MACRO(n) type_list(~, n, BOOST_PP_SEQ_TRANSFORM( type2string, , paramtypes), paramreferences)
#define BOOST_PP_LOCAL_LIMITS  (0, MAXPARAMTYPES-1)
#include BOOST_PP_LOCAL_ITERATE()
#endif
	);
}

void BOOST_PP_CAT(export_, COMMAND)()
{
  std::string docstring =
    std::string( DESCRIPTION ) + "\n\n"
#if defined paramtokens && defined paramdescriptions
#define BOOST_PP_LOCAL_MACRO(n) help_print(~, n, paramtokens, paramdescriptions, " - ", "\n")
#define BOOST_PP_LOCAL_LIMITS  (0, MAXPARAMTYPES-1)
#include BOOST_PP_LOCAL_ITERATE()
#endif
  ;
  boost::python::def(
    BOOST_PP_STRINGIZE(COMMAND),
    MoleCuilder:: BOOST_PP_CAT( COMMAND, _stringargs)
#if defined paramtokens // do we have parameters at all?
   ,(
#if defined paramdefaults
#define BOOST_PP_LOCAL_MACRO(n) stringdefault_print(~, n, paramtokens, paramdefaults)
#else
#define BOOST_PP_LOCAL_MACRO(n) string_print(~, n, paramtokens)
#endif
#define BOOST_PP_LOCAL_LIMITS  (0, MAXPARAMTYPES-1)
#include BOOST_PP_LOCAL_ITERATE()
  ), docstring.c_str()
#endif
  );
}

#undef COMMAND
#undef ACTION
#undef PARAMS
#undef MAXPARAMTYPES

#undef help_print
#undef string_print
#undef stringdefault_print
#undef type_list
#undef value_print

#undef type2string
#undef stringtype
