/*
 * QtMoleculeItem_occurrence.hpp
 *
 *  Created on: Jan 18, 2015
 *      Author: heber
 */

#ifndef QTMOLECULEITEM_OCCURRENCE_HPP_
#define QTMOLECULEITEM_OCCURRENCE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Views/Qt4/MoleculeList/QtMoleculeItem.hpp"

class QtMoleculeItemFactory;

/** This class contains the occurrence of a molecule.
 *
 */
class QtMoleculeItem_occurrence : public QtMoleculeItem
{
  //!> only allow factory to instantiate items
  friend class QtMoleculeItemFactory;

  QtMoleculeItem_occurrence(
      const moleculeId_t _molid,
      emitDirtyState_t _emitDirtyState) :
        QtMoleculeItem(_molid, channellist_occurrence, QtMoleculeItem::DoesNotMove, _emitDirtyState)
  {
    // cannot call pure virtual function in QtMoleculeItem's cstor
    internal_updateState();
  }

  /** Performs the update of the molecule's occurrence.
   *
   */
  void internal_updateState()
  {
    setText(QString(""));
  }

  //!> notification channels of molecule specific to this molecule item, required for update
  static const QtMoleculeItem::channellist_t channellist_occurrence;
};



#endif /* QTMOLECULEITEM_OCCURRENCE_HPP_ */
