/*
 * QtMoleculeItem_atomcount.hpp
 *
 *  Created on: Jan 18, 2015
 *      Author: heber
 */

#ifndef QTMOLECULEITEM_ATOMCOUNT_HPP_
#define QTMOLECULEITEM_ATOMCOUNT_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Views/Qt4/MoleculeList/QtMoleculeItem.hpp"

#include "Descriptors/MoleculeIdDescriptor.hpp"
#include "molecule.hpp"
#include "World.hpp"

class QtMoleculeItemFactory;

/** This class contains the atomcount of a molecule and keeps it up to date.
 *
 */
class QtMoleculeItem_atomcount : public QtMoleculeItem
{
  //!> only allow factory to instantiate items
  friend class QtMoleculeItemFactory;

  QtMoleculeItem_atomcount(
      const moleculeId_t _molid,
      emitDirtyState_t _emitDirtyState) :
        QtMoleculeItem(_molid, channellist_atomcount, QtMoleculeItem::NeedsMove, _emitDirtyState)
  {
    // cannot call pure virtual function in QtMoleculeItem's cstor
    internal_updateState();
  }

  /** Performs the update of the molecule's atomcount.
   *
   */
  void internal_updateState()
  {
    const molecule * mol = World::getInstance().getMolecule(MoleculeById(molid));
    if (mol != NULL)
      setText(QString::number(mol->getAtomCount()));
    else
      setText(QString::number(-1));
  }

  //!> notification channels of molecule specific to this molecule item, required for update
  static const QtMoleculeItem::channellist_t channellist_atomcount;
};



#endif /* QTMOLECULEITEM_ATOMCOUNT_HPP_ */
