/*
 * ManipulateAtomsProcess.hpp
 *
 *  Created on: Feb 18, 2010
 *      Author: crueger
 */

#ifndef MANIPULATEATOMSPROCESS_HPP_
#define MANIPULATEATOMSPROCESS_HPP_

#include "Actions/Process.hpp"

#include<boost/function.hpp>

#include "Descriptors/AtomDescriptor.hpp"

class World;

class ManipulateAtomsProcess : public Process
{
public:
  ManipulateAtomsProcess(boost::function<void(atom*)> _operation, AtomDescriptor descr,std::string _name,bool _doRegister=true);
  virtual ~ManipulateAtomsProcess();

  virtual bool canUndo();
  virtual bool shouldUndo();

  virtual void doManipulate(World *);
private:

  virtual ActionState* performCall();
  virtual ActionState* performUndo(ActionState*);
  virtual ActionState* performRedo(ActionState*);

  AtomDescriptor descr;
  boost::function<void(atom*)> operation;
};

#endif /* MANIPULATEATOMSPROCESS_HPP_ */
