/*
 * ManipulateAtomsProcess.cpp
 *
 *  Created on: Feb 18, 2010
 *      Author: crueger
 */

#include "ManipulateAtomsProcess.hpp"

#include <iostream>

#include "World.hpp"
#include "Helpers/Assert.hpp"

using namespace std;

ManipulateAtomsProcess::ManipulateAtomsProcess(boost::function<void(atom*)> _operation, AtomDescriptor _descr,
                                               std::string _name,bool _doRegister) :
  Process(0,_name,_doRegister),
  descr(_descr),
  operation(_operation)
{}

ManipulateAtomsProcess::~ManipulateAtomsProcess()
{}

ActionState* ManipulateAtomsProcess::performCall(){
  World::getInstance().doManipulate(this);
  return Action::success;
}

ActionState* ManipulateAtomsProcess::performUndo(ActionState*){
  ASSERT(0,"Undo called for a ManipulateAtomsProcess");
  return Action::success;
}

ActionState* ManipulateAtomsProcess::performRedo(ActionState*){
  ASSERT(0,"Redo called for a ManipulateAtomsProcess");
  return Action::success;
}

bool ManipulateAtomsProcess::canUndo(){
  return false;
}

bool ManipulateAtomsProcess::shouldUndo(){
  return true;
}

void ManipulateAtomsProcess::doManipulate(World *world){
  setMaxSteps(world->numAtoms());
  start();
  for(World::AtomIterator iter=world->getAtomIter(descr);iter!=world->atomEnd();++iter){
    setCurrStep(iter.getCount());
    operation(*iter);
  }
  stop();
}
