/*
 * MakroAction.cpp
 *
 *  Created on: Dec 17, 2009
 *      Author: crueger
 */

#include <string>

#include "Actions/MakroAction.hpp"
#include "Actions/Action.hpp"
#include "Actions/ActionSequence.hpp"
#include "Helpers/Assert.hpp"

using namespace std;

class MakroActionState : public ActionState{
public:
  MakroActionState(ActionSequence::stateSet _states) :
    states(_states)
  {}
  virtual ~MakroActionState(){
    for(ActionSequence::stateSet::iterator iter=states.begin();
        iter!=states.end();++iter){
      delete *iter;
    }
  }

  ActionSequence::stateSet states;
};

MakroAction::MakroAction(string _name,ActionSequence* _actions,bool _doRegister) :
Action(_name,_doRegister),
actions(_actions)
{
}

MakroAction::~MakroAction()
{
  Action* action;
  while((action=actions->removeLastAction())){
    delete action;
  }
  delete actions;
}


ActionState* MakroAction::performCall(){
  ActionSequence::stateSet states = actions->callAll();
  return new MakroActionState(states);
}

ActionState* MakroAction::performUndo(ActionState* _state) {
  MakroActionState *state = dynamic_cast<MakroActionState*>(_state);
  ASSERT(state,"Type mismatch for the state of the MakroAction");
  ActionSequence::stateSet states = actions->undoAll(state->states);
  return new MakroActionState(states);
}

bool MakroAction::canUndo() {
  return actions->canUndo();
}

bool MakroAction::shouldUndo() {
  return actions->shouldUndo();
}
