/*
 * ErrorAction.cpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

#include <iostream>

#include "Actions/ErrorAction.hpp"
#include "log.hpp"
#include "verbose.hpp"
#include "Helpers/Assert.hpp"

using namespace std;

ErrorAction::ErrorAction(string _name,const char * _errorMsg,bool _doRegister) :
Action(_name,_doRegister),
errorMsg(_errorMsg)
{
}

ErrorAction::~ErrorAction()
{
}

ActionState* ErrorAction::performCall() {
  Log() << Verbose(0) << errorMsg << endl;
  return Action::success;
}
ActionState* ErrorAction::performUndo(ActionState*) {
  ASSERT(0,"Undo called for an ErrorAction");
  return Action::success;
}

ActionState* ErrorAction::performRedo(ActionState*) {
  ASSERT(0,"Redo called for an ErrorAction");
  return Action::success;
}

bool ErrorAction::canUndo(){
  return false;
}

bool ErrorAction::shouldUndo(){
  return false;
}
