/*
 * Action.h
 *
 *  Created on: Dec 8, 2009
 *      Author: crueger
 */

#ifndef ACTION_H_
#define ACTION_H_

#include <string>

// forward declaration

class ActionState;
class ActionSequence;

/**
 * Base class for all actions.
 *
 * Actions describe something that has to be done.
 * Actions can be passed around, stored, performed and undone (Command-Pattern).
 *
 * TODO: Add queues of actions that have been performed to allow easy implementation of multiple-step undo
 */
class Action
{
friend class ActionSequence;
public:
  Action(std::string _name,bool _doRegister=true);
  virtual ~Action();

  // this method only handles the infrastructure
  // actuall action is passed on to a private virtual
  void call();
  ActionState* undo(ActionState*);
  ActionState* redo(ActionState*);

  virtual bool canUndo()=0;
  virtual bool shouldUndo()=0;

  virtual const std::string getName();

protected:
  static ActionState* success;

private:
  virtual ActionState* performCall()=0;
  virtual ActionState* performUndo(ActionState*)=0;
  virtual ActionState* performRedo(ActionState*)=0;

  std::string name;
};

/**
 * This class can be used by actions to save the state.
 *
 * It is implementing a memento pattern. The base class is completely empty,
 * since no general state internals can be given. The Action performing
 * the Undo should downcast to the apropriate type.
 */
class ActionState{
public:
  ActionState(){}
  virtual ~ActionState(){}
};

#endif /* ACTION_H_ */
