/*
 * Action.cpp
 *
 *  Created on: Dec 8, 2009
 *      Author: crueger
 */

#include <string>

#include "Actions/Action.hpp"
#include "Actions/ActionRegistry.hpp"

using namespace std;

// this object is only ever used as indicator.
ActionState success_val;

ActionState *Action::success = &success_val;

Action::Action(std::string _name,bool _doRegister) :
name(_name)
{
  if(_doRegister){
    ActionRegistry::getInstance().registerAction(this);
  }
}

Action::~Action()
{}

const string Action::getName(){
  return name;
}

void Action::call(){
  // forward to private virtual
  performCall();
}
ActionState* Action::undo(ActionState* _state) {
  // forward to private virtual
  return performUndo(_state);
}
ActionState* Action::redo(ActionState* _state) {
  // forward to private virtual
  return performRedo(_state);
}
