/*
 * MethodAction.cpp
 *
 *  Created on: Dec 11, 2009
 *      Author: crueger
 */

#include "Helpers/MemDebug.hpp"

#include <iostream>
#include <boost/function.hpp>
#include <string>

#include "Actions/MethodAction.hpp"
#include "Helpers/Assert.hpp"

using namespace std;

MethodAction::MethodAction(string _name,boost::function<void()> _executeMethod,bool _doRegister) :
   Action(_name,_doRegister),
executeMethod(_executeMethod)
{
}

MethodAction::~MethodAction()
{}

Dialog* MethodAction::createDialog() {
  return NULL;
}


Action::state_ptr MethodAction::performCall() {
  executeMethod();
  // we don't have a state to save so we return Action::success
  return Action::success;
}

Action::state_ptr MethodAction::performUndo(Action::state_ptr) {
  ASSERT(0,"Cannot undo a MethodAction");
  return Action::success;
}

Action::state_ptr MethodAction::performRedo(Action::state_ptr){
  ASSERT(0,"Cannot redo a MethodAction");
  return Action::success;
}

bool MethodAction::canUndo() {
  return false;
}

bool MethodAction::shouldUndo(){
  return true;
}
