/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * stackclassunittest.cpp
 *
 *  Created on: Oct 27, 2009
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "stackclassunittest.hpp"
#include "Helpers/Log.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

enum { testdimension=3 };

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( StackClassTest );


void StackClassTest::setUp()
{
  Stack = new StackClass<int *>(testdimension);
};


void StackClassTest::tearDown()
{
  Stack->ClearStack();
  delete(Stack);
  logger::purgeInstance();
};

/** UnitTest for StackClass<T> implementation
 *
 */

void StackClassTest::TestImplementation()
{
  int testfield[testdimension] = {0,1,2};
  //Log() << Verbose(1) << "Testing the snake stack..." << endl;
  for (int i=0;i<testdimension;i++) {
    //Log() << Verbose(2) << "Filling " << i << "th element of stack." << endl;
    Stack->Push(&testfield[i]);
  }
  //Log() << Verbose(0) << endl;
  //Output(out);
  CPPUNIT_ASSERT_EQUAL(true, Stack->IsFull());
  CPPUNIT_ASSERT_EQUAL(false, Stack->IsEmpty());
  CPPUNIT_ASSERT_EQUAL((testdimension) % (int)testdimension, Stack->ItemCount());

  CPPUNIT_ASSERT_EQUAL( true, Stack->RemoveItem(&testfield[1]) );
  CPPUNIT_ASSERT_EQUAL((testdimension-1) % (int)testdimension, Stack->ItemCount());

  CPPUNIT_ASSERT_EQUAL( true, Stack->RemoveItem(&testfield[2]) );
  CPPUNIT_ASSERT_EQUAL((testdimension-2) % (int)testdimension, Stack->ItemCount());

  CPPUNIT_ASSERT_EQUAL( true, Stack->RemoveItem(&testfield[0]) );
  CPPUNIT_ASSERT_EQUAL((testdimension-3) % (int)testdimension, Stack->ItemCount());

  Stack->ClearStack();
  CPPUNIT_ASSERT_EQUAL(false, Stack->IsFull());
  CPPUNIT_ASSERT_EQUAL(true, Stack->IsEmpty());
  CPPUNIT_ASSERT_EQUAL(0, Stack->ItemCount());
};
