/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * logunittest.cpp
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "logunittest.hpp"
#include "Helpers/Log.hpp"
#include "defs.hpp"
#include "Helpers/Verbose.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( LogTest );


void LogTest::setUp()
{
};

void LogTest::tearDown()
{
  logger::purgeInstance();
  errorLogger::purgeInstance();
};

/**
 * UnitTest for log()
 */
void LogTest::logTest()
{
  logger::getInstance().setVerbosity(2);
  DoLog(0) && (Log() << Verbose(0) << "Verbosity level is set to 2." << endl);
  DoLog(0) && (Log() << Verbose(0) << "Test level 0" << endl);
  DoLog(1) && (Log() << Verbose(1) << "Test level 1" << endl);
  DoLog(2) && (Log() << Verbose(2) << "Test level 2" << endl);
  DoLog(3) && (Log() << Verbose(3) << "Test level 3" << endl);
  DoLog(4) && (Log() << Verbose(4) << "Test level 4" << endl);

  DoLog(0) && (Log() << Verbose(0) << "Output a log message." << endl);
  DoeLog(0) && (eLog()<< Verbose(0) << "Output an error message." << endl);
  setVerbosity(3);
  DoLog(4) && (Log() << Verbose(4) << "This should not be printed." << endl);
  DoeLog(4) && (eLog()<< Verbose(4) << "This should not be printed." << endl);
};
