/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * linearsystemofequationsunittest.cpp
 *
 *  Created on: Jan 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include <iomanip>
#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>
#include <cmath>

#include "linearsystemofequationsunittest.hpp"
#include "LinearAlgebra/Vector.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( LinearSystemOfEquationsTest );


void LinearSystemOfEquationsTest::setUp()
{
  s = new LinearSystemOfEquations(4,4);
};

void LinearSystemOfEquationsTest::tearDown()
{
  delete(s);
};

/** Unit test for initialization.
 *
 */
void LinearSystemOfEquationsTest::InitializationTest()
{
  // Setting A
  double array[] = { 1., 0., 0., 0.,
                     0., 2., 0., 0.,
                     0., 0., 3., 0.,
                     0., 0., 0., 4. };
  s->SetA(array);

  // Setting b
};

/** Unit test for symmetry property.
 *
 */
void LinearSystemOfEquationsTest::SymmetricTest()
{
  CPPUNIT_ASSERT_EQUAL( true, s->SetSymmetric(true) );
  //LinearSystemOfEquations *t = new LinearSystemOfEquations(4,3);
  //CPPUNIT_ASSERT_EQUAL( true, t->SetSymmetric(true) );
  //delete(t);
};

/** Unit test for simple Solve.
 *
 */
void LinearSystemOfEquationsTest::SolveSimpleTest()
{
  // set up A and b
  double m_array[] = { 1., 0., 0., 0.,
                       0., 2., 0., 0.,
                       0., 0., 3., 0.,
                       0., 0., 0., 4. };
  double v_array[] = { 1., 2., 3., 4. };
  s->SetA(m_array);
  s->Setb(v_array);

  // solve
  double *array = new double[4];
  s->GetSolutionAsArray(array);
  for (int i=0;i<4;i++)
    CPPUNIT_ASSERT_EQUAL( 1., array[i]);
  delete[](array);
};

/** Unit test for advanced Solve.
 *
 */
void LinearSystemOfEquationsTest::SolveAdvancedTest()
{
  // set up A and b
  double m_array[] = { 0.18, 0.60, 0.57, 0.96,
                       0.41, 0.24, 0.99, 0.58,
                       0.14, 0.30, 0.97, 0.66,
                       0.51, 0.13, 0.19, 0.85 };
  double v_array[] = { 1.0, 2.0, 3.0, 4.0 };
  double x_array[] = { -4.05205022957398, -12.60561139590692, 1.660911626708844, 8.693766928795233 };
  s->SetA(m_array);
  s->Setb(v_array);

  // solve
  double *array = new double[4];
  s->GetSolutionAsArray(array);
  for (int i=0;i<4;i++) {
    CPPUNIT_ASSERT( fabs(x_array[i] - array[i]) < MYEPSILON );
  }
  delete[](array);
};
