/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * BaseShapesUnittest.cpp
 *
 *  Created on: Jun 18, 2010
 *      Author: crueger
 */

#include "BaseShapesUnittest.hpp"

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include <cmath>

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

#include "LinearAlgebra/Vector.hpp"
#include "Shapes/Shape.hpp"

#include "Shapes/BaseShapes.hpp"

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( BaseShapesUnittest );

void BaseShapesUnittest::setUp()
{
  v000 =  0*e1+0*e2+0*e3;
  v100 =  1*e1+0*e2+0*e3;
  v200 = -1*e1+0*e2+0*e3;
  v010 =  0*e1+1*e2+0*e3;
  v110 =  1*e1+1*e2+0*e3;
  v210 = -1*e1+1*e2+0*e3;
  v020 =  0*e1-1*e2+0*e3;
  v120 =  1*e1-1*e2+0*e3;
  v220 = -1*e1-1*e2+0*e3;
  v001 =  0*e1+0*e2+1*e3;
  v101 =  1*e1+0*e2+1*e3;
  v201 = -1*e1+0*e2+1*e3;
  v011 =  0*e1+1*e2+1*e3;
  v111 =  1*e1+1*e2+1*e3;
  v211 = -1*e1+1*e2+1*e3;
  v021 =  0*e1-1*e2+1*e3;
  v121 =  1*e1-1*e2+1*e3;
  v221 = -1*e1-1*e2+1*e3;
  v002 =  0*e1+0*e2-1*e3;
  v102 =  1*e1+0*e2-1*e3;
  v202 = -1*e1+0*e2-1*e3;
  v012 =  0*e1+1*e2-1*e3;
  v112 =  1*e1+1*e2-1*e3;
  v212 = -1*e1+1*e2-1*e3;
  v022 =  0*e1-1*e2-1*e3;
  v122 =  1*e1-1*e2-1*e3;
  v222 = -1*e1-1*e2-1*e3;
}

void BaseShapesUnittest::tearDown()
{}


void BaseShapesUnittest::isInsideTest(){
  Shape s1 = Sphere();

  CPPUNIT_ASSERT(s1.isInside(v000));
  CPPUNIT_ASSERT(s1.isInside(v100));
  CPPUNIT_ASSERT(s1.isInside(v200));
  CPPUNIT_ASSERT(s1.isInside(v010));
  CPPUNIT_ASSERT(!s1.isInside(v110));
  CPPUNIT_ASSERT(!s1.isInside(v210));
  CPPUNIT_ASSERT(s1.isInside(v020));
  CPPUNIT_ASSERT(!s1.isInside(v120));
  CPPUNIT_ASSERT(!s1.isInside(v220));
  CPPUNIT_ASSERT(s1.isInside(v001));
  CPPUNIT_ASSERT(!s1.isInside(v101));
  CPPUNIT_ASSERT(!s1.isInside(v201));
  CPPUNIT_ASSERT(!s1.isInside(v011));
  CPPUNIT_ASSERT(!s1.isInside(v111));
  CPPUNIT_ASSERT(!s1.isInside(v211));
  CPPUNIT_ASSERT(!s1.isInside(v021));
  CPPUNIT_ASSERT(!s1.isInside(v121));
  CPPUNIT_ASSERT(!s1.isInside(v221));
  CPPUNIT_ASSERT(s1.isInside(v002));
  CPPUNIT_ASSERT(!s1.isInside(v102));
  CPPUNIT_ASSERT(!s1.isInside(v202));
  CPPUNIT_ASSERT(!s1.isInside(v012));
  CPPUNIT_ASSERT(!s1.isInside(v112));
  CPPUNIT_ASSERT(!s1.isInside(v212));
  CPPUNIT_ASSERT(!s1.isInside(v022));
  CPPUNIT_ASSERT(!s1.isInside(v122));
  CPPUNIT_ASSERT(!s1.isInside(v222));

  Shape s2 = Cuboid();

  CPPUNIT_ASSERT(s2.isInside(v000));
  CPPUNIT_ASSERT(s2.isInside(v100));
  CPPUNIT_ASSERT(!s2.isInside(v200));
  CPPUNIT_ASSERT(s2.isInside(v010));
  CPPUNIT_ASSERT(s2.isInside(v110));
  CPPUNIT_ASSERT(!s2.isInside(v210));
  CPPUNIT_ASSERT(!s2.isInside(v020));
  CPPUNIT_ASSERT(!s2.isInside(v120));
  CPPUNIT_ASSERT(!s2.isInside(v220));
  CPPUNIT_ASSERT(s2.isInside(v001));
  CPPUNIT_ASSERT(s2.isInside(v101));
  CPPUNIT_ASSERT(!s2.isInside(v201));
  CPPUNIT_ASSERT(s2.isInside(v011));
  CPPUNIT_ASSERT(s2.isInside(v111));
  CPPUNIT_ASSERT(!s2.isInside(v211));
  CPPUNIT_ASSERT(!s2.isInside(v021));
  CPPUNIT_ASSERT(!s2.isInside(v121));
  CPPUNIT_ASSERT(!s2.isInside(v221));
  CPPUNIT_ASSERT(!s2.isInside(v002));
  CPPUNIT_ASSERT(!s2.isInside(v102));
  CPPUNIT_ASSERT(!s2.isInside(v202));
  CPPUNIT_ASSERT(!s2.isInside(v012));
  CPPUNIT_ASSERT(!s2.isInside(v112));
  CPPUNIT_ASSERT(!s2.isInside(v212));
  CPPUNIT_ASSERT(!s2.isInside(v022));
  CPPUNIT_ASSERT(!s2.isInside(v122));
  CPPUNIT_ASSERT(!s2.isInside(v222));

}

void BaseShapesUnittest::PointsOnSurfaceTest(){
  Shape s = Sphere();
  const size_t N = 200;
  std::vector<Vector> PointsOnSurface = s.getHomogeneousPointsOnSurface(N);
  for (std::vector<Vector>::const_iterator iter = PointsOnSurface.begin(); iter != PointsOnSurface.end(); ++iter) {
    CPPUNIT_ASSERT(fabs(1. - (*iter).NormSquared()) < MYEPSILON);
  }
  CPPUNIT_ASSERT_EQUAL(N, PointsOnSurface.size());
}

