/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * leastsquaremin.cpp
 *
 *  Created on: Aug 18, 2009
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include <iostream>

#include "leastsquaremin.hpp"
#include "LinearAlgebra/Vector.hpp"

/** Determines sum of squared distances of \a X to all \a **vectors.
 * \param *x reference vector
 * \param *params
 * \return sum of square distances
 */
double LSQ (const gsl_vector * const x, void * params)
{
  double sum = 0.;
  struct LSQ_params *par = (struct LSQ_params *)params;
  const Vector ** vectors = par->vectors;
  int num = par->num;

  for (int i=num;i--;) {
    for(int j=NDIM;j--;)
      sum += (gsl_vector_get(x,j) - (vectors[i])->at(j))*(gsl_vector_get(x,j) - (vectors[i])->at(j));
  }

  return sum;
};

