/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/** \file graph.cpp
 *
 * Function implementations for the class graph.
 *
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

using namespace std;

#include "atom.hpp"
#include "bond.hpp"
#include "config.hpp"
#include "graph.hpp"
#include "Helpers/Verbose.hpp"
#include "Helpers/Log.hpp"
#include "molecule.hpp"

/***************************************** Implementations for graph classes ********************************/

///** Constructor of class Graph.
// */
//Graph::Graph()
//{
//};
//
///** Destructor of class Graph.
// * Destructor does release memory for nodes and edges contained in its lists as well.
// */
//Graph::~Graph()
//{
//};
//
///** Constructor of class SubGraph.
// */
//SubGraph::SubGraph()
//{
//};
//
///** Destructor of class SubGraph.
// * Note that destructor does not deallocate either nodes or edges! (this is done by its subgraph!)
// */
//SubGraph::~SubGraph()
//{
//};
//
///** Constructor of class Node.
// */
//Node::Node()
//{
//};
//
///** Destructor of class Node.
// */
//Node::~Node()
//{
//};
//
///** Constructor of class Edge.
// */
//Edge::Edge()
//{
//};
//
///** Destructor of class Edge.
// */
//Edge::~Edge()
//{
//};


//bool operator < (KeySet SubgraphA, KeySet SubgraphB)
//{
//  return KeyCompare(SubgraphA, SubgraphB);
//};

/** Checking whether KeySet is not already present in Graph, if so just adds factor.
 * \param *out output stream for debugging
 * \param &set KeySet to insert
 * \param &graph Graph to insert into
 * \param *counter pointer to unique fragment count
 * \param factor energy factor for the fragment
 */
void InsertFragmentIntoGraph(struct UniqueFragments *Fragment)
{
  GraphTestPair testGraphInsert;

  testGraphInsert = Fragment->Leaflet->insert(GraphPair (*Fragment->FragmentSet,pair<int,double>(Fragment->FragmentCounter,Fragment->TEFactor)));  // store fragment number and current factor
  if (testGraphInsert.second) {
    DoLog(2) && (Log() << Verbose(2) << "KeySet " << Fragment->FragmentCounter << " successfully inserted." << endl);
    Fragment->FragmentCounter++;
  } else {
    DoLog(2) && (Log() << Verbose(2) << "KeySet " << Fragment->FragmentCounter << " failed to insert, present fragment is " << ((*(testGraphInsert.first)).second).first << endl);
    ((*(testGraphInsert.first)).second).second += Fragment->TEFactor;  // increase the "created" counter
    DoLog(2) && (Log() << Verbose(2) << "New factor is " << ((*(testGraphInsert.first)).second).second << "." << endl);
  }
};
//void inline InsertIntoGraph(KeyStack &stack, Graph &graph, int *counter, double factor)
//{
//  // copy stack contents to set and call overloaded function again
//  KeySet set;
//  for(KeyStack::iterator runner = stack.begin(); runner != stack.begin(); runner++)
//    set.insert((*runner));
//  InsertIntoGraph(set, graph, counter, factor);
//};

/** Inserts each KeySet in \a graph2 into \a graph1.
 * \param *out output stream for debugging
 * \param graph1 first (dest) graph
 * \param graph2 second (source) graph
 * \param *counter keyset counter that gets increased
 */
void InsertGraphIntoGraph(Graph &graph1, Graph &graph2, int *counter)
{
  GraphTestPair testGraphInsert;

  for(Graph::iterator runner = graph2.begin(); runner != graph2.end(); runner++) {
    testGraphInsert = graph1.insert(GraphPair ((*runner).first,pair<int,double>((*counter)++,((*runner).second).second)));  // store fragment number and current factor
    if (testGraphInsert.second) {
      DoLog(2) && (Log() << Verbose(2) << "KeySet " << (*counter)-1 << " successfully inserted." << endl);
    } else {
      DoLog(2) && (Log() << Verbose(2) << "KeySet " << (*counter)-1 << " failed to insert, present fragment is " << ((*(testGraphInsert.first)).second).first << endl);
      ((*(testGraphInsert.first)).second).second += (*runner).second.second;
      DoLog(2) && (Log() << Verbose(2) << "New factor is " << (*(testGraphInsert.first)).second.second << "." << endl);
    }
  }
};

