/*
 * element.hpp
 *
 *  Created on: Aug 3, 2009
 *      Author: heber
 */

#ifndef ELEMENT_HPP_
#define ELEMENT_HPP_

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iosfwd>
#include <string>

#include "defs.hpp"
#include "types.hpp"

class periodentafel;

/********************************************** declarations *******************************/

/** Chemical element.
 * Class incorporates data for a certain chemical element to be referenced from atom class.
 */
class element {
  friend class periodentafel;
  public:
    element();
    element(const element&);
    ~element();

    element &operator=(const element&);

    // accessor functions
    atomicNumber_t getNumber() const;
    double getMass() const;
    double getCovalentRadius() const;
    double getVanDerWaalsRadius() const;
    int getAtomicNumber() const;
    double getValence() const;
    int getNoValenceOrbitals() const;
    double getHBondDistance(const int i) const;
    double getHBondAngle(const int i) const;

    std::string &getSymbol();
    const std::string &getSymbol() const;
    void setSymbol(const std::string &temp);

    std::string &getName();
    const std::string &getName() const;
    void setName(const std::string &temp);

    //> print element entries to screen
    bool Output(std::ostream * const out) const;
    bool Checkout(std::ostream * const out, const int No, const int NoOfAtoms) const;

  private:
    double mass;    //!< mass in g/mol
    double CovalentRadius;  //!< covalent radius
    double VanDerWaalsRadius;  //!< can-der-Waals radius
    int Z;          //!< atomic number
    std::string period;    //!< period: n quantum number
    std::string group;    //!< group: l quantum number
    std::string block;    //!< block: l quantum number
    double Valence;   //!< number of valence electrons for this element
    int NoValenceOrbitals;  //!< number of valence orbitals, used for determining bond degree in molecule::CreateConnectmatrix()
    double HBondDistance[NDIM]; //!< distance in Angstrom of this element to hydrogen  (for single, double and triple bonds)
    double HBondAngle[NDIM];     //!< typical angle for one, two, three bonded hydrogen (in degrees)

    std::string name;  //!< atom name, i.e. "Hydrogen"
    std::string symbol; //!< short form of the atom, i.e. "H"
};

std::ostream &operator<<(std::ostream&,const element&);

#endif /* ELEMENT_HPP_ */
